import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.lang.reflect.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.Border;
import java.text.DecimalFormat;

class PaintArea extends JPanel {

    private Dimension preferredSize = new Dimension(600,500);
    private RegressionsGeradenGenerator rgg;
    public PaintArea(RegressionsGeradenGenerator RGG) {
        this.rgg = RGG;
        Border raisedBevel = BorderFactory.createRaisedBevelBorder();
        Border loweredBevel = BorderFactory.createLoweredBevelBorder();
        Border compound = BorderFactory.createCompoundBorder
                              (raisedBevel, loweredBevel);
        setBorder(compound);
        repaint();
    }
    public void paintGraphic(RegressionsGeradenGenerator RGG) {
        this.rgg = RGG; repaint();
    }
    public void paintComponent(Graphics g) {
        super.paintComponent(g);  //paint background
        rgg.drawBackground(g);
        rgg.paintKoordinatensystem(g);
        rgg.drawXYPoints(g);
        rgg.drawGxLine(g);
    }
    public Dimension getPreferredSize() {
        preferredSize = new Dimension(rgg.g_weight,rgg.g_height);
        return preferredSize;
    }

}
class TextArea extends JPanel {

    private static final int weight=800;
    private static final int height=100;
    private static final Dimension preferredSize = new Dimension(weight,height);
    private RegressionsGeradenGenerator rgg;
    public TextArea(RegressionsGeradenGenerator RGG) {
        this.rgg = RGG;
        Border raisedBevel = BorderFactory.createRaisedBevelBorder();
        Border loweredBevel = BorderFactory.createLoweredBevelBorder();
        Border compound = BorderFactory.createCompoundBorder
                              (raisedBevel, loweredBevel);
        setBorder(compound);
        repaint();
    }
    public void paintGraphic(RegressionsGeradenGenerator RGG) {
        this.rgg = RGG; repaint();
    }
    public void paintComponent(Graphics g) {
        super.paintComponent(g);  //paint background
        drawBackground(g);
        rgg.drawText(g);
    }
    public Dimension getPreferredSize() {
        return preferredSize;
    }
    public void drawBackground(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0,0,weight+20,height);
  }

}

public class RegressionsGeradenGenerator extends JApplet

  implements ActionListener {

  private JLabel label1,label2,label3;
  private JButton jb;
  private String Xwerte;
  private String Ywerte;
  private String s_n;
  private String gx;
  private String gy;
  private String s_xquer;
  private String s_yquer;
  private String s_sxy ;
  private String s_xmax;
  private String s_ymax;
  private String s_zero;
  private String s_r;
  private String s_sx;
  private String s_sy;
  private Image img;
  private static final int offset=20;
  private static final int xoffset=80;
  private static final int yoffset=20;
  private static final int x_weight=550;
  private static final int y_height=300;
  public static final int g_weight=x_weight+2*yoffset+xoffset;
  public static final int g_height=y_height+2*yoffset+yoffset;

  private static final int g_xstart=280;
  private static final int g_ystart=90;
  private JPanel panel = new JPanel(new BorderLayout());
  private JPanel subpanel1 = new JPanel(new BorderLayout());
  private JPanel subpanel2 = new JPanel(new BorderLayout());
  private JPanel subpanel3 = new JPanel(new BorderLayout());
  private JTable jt = new JTable();
  private PaintArea pa = new PaintArea(this);
  private TextArea ta = new TextArea(this);
  private static final Color xcolor = Color.blue;
  private static final Color ycolor = Color.magenta;
  String[][] data = new String [22][2];
  String[] columnNames = {"x","y"};
  public static final int dotwith= 5;

  // Skalierung zwischen Koordinatensystem und Visualisierung
  private double Xscale;
  private double Yscale;

  // Kovarianz
  private double sxy;

  // Standardabweichungen
  private double sx;
  private double sy;

  // emperischer Korrelationskoeffizient
  private double r;

  // x Mittelwert
  private double xquer;
  private double yquer;

  // x und y max
  private double Xmax;
  private double Ymax;

  // Anzahl von Wertepaaren
  public int n;

  // Summierung von x und y
  private double sumX;
  private double sumY;

  //Summierung von X^2-Werten
  private double sumXhoch2;

  //Summierung von Y^2-Werten
  private double sumYhoch2;

  //Summierung von X*Y-Werten
  private double sumXY;

  private double Xsummanden;
  private double Ysummanden;
  // g(x)
  private double ax;
  private double bx;

  // g(y)
  private double ay;
  private double by;

  // Liste von x und y Werten
  public ArrayList x = new ArrayList();
  public ArrayList y = new ArrayList();

  public void init() {

    this.getContentPane().setLayout(new FlowLayout());
    initValues();
    label1 = new JLabel ("*** REGRESSIONSGERADEN-GENERATOR MIT BERECHNUNG DES KORRELATIONSKOEFFIZIENTEN ***");
    label2 = new JLabel ("   Bitte geben Sie in die Tabelle von oben an XY-Wertepaare ein   ");
    jb = new JButton ("bernahme der XY-Wertetabelle");
    jb.setBackground(new Color(225,225,225));

    jb.addActionListener(this);
    jt = new JTable(data,columnNames);

    subpanel1.add(label1,"North");
    subpanel1.add(label2,"West");
    subpanel1.add(jb,"East");

    this.getContentPane().add(subpanel1);

    subpanel2.add(jt.getTableHeader(),"North");
    subpanel2.add(jt,"South");

    panel.add(subpanel2,"West");
    panel.add(pa,"East");
    panel.add(ta,"South");

    this.getContentPane().add(panel);
  }

  public void initValues(){
    Xwerte="x-Werte: ";
    Ywerte="y-Werte: ";
    s_n="Anzahl von Wertepaaren n = ";
    gx = "Regressionsgerade fr x unabhngig g(x)=";
    gy = "Regressionsgerade fr y unabhngig g(y)=";
    s_sx = "Standardabweichung von x = ";
    s_sy = "Standardabweichung von y = ";
    s_sxy = "Kovarianz sxy = ";
    s_xmax = String.valueOf(x_weight);
    s_ymax = String.valueOf(y_height);
    s_zero = "0";
    s_r="empirischer Korrelationskoeffizient r = ";
    s_xquer="Mittelwert von x = ";
    s_yquer="Mittelwert von y = ";
    Xscale=1; Yscale=1;
    sxy = 0;
    sx = 0; sy = 0;
    r = 0;
    xquer = 0; yquer = 0;
    Xmax=0; Ymax=0;
    Xsummanden = 0; Ysummanden = 0;
    n=0;
    sumX=0;
    sumY=0;
    sumXhoch2=0;
    sumYhoch2=0;
    sumXY=0;
    ax=0; bx=0;
    ay=0; by=0;
    x.clear(); y.clear();
  }

  public int XKonv (double Value) {
    return (int) (Value * Xscale) + xoffset;
  }

  public int YKonv (double Value) {
    return g_height - (int) (Value * Yscale) - yoffset;
  }

  public void paintKoordinatensystem (Graphics g) {

    int xbase = (int) Math.pow(10,String.valueOf((int) Xmax).length()-1);
    int ybase = (int) Math.pow(10,String.valueOf((int) Ymax).length()-1);
    if ( xbase > 1 ) {
       if (Xmax <= 1.5*xbase ) { xbase = xbase/10;} 
       else if (Xmax <= 7.5*xbase ) { xbase = xbase/2; }
    }   
    if ( ybase > 1 ) {
       if (Ymax <= 1.5*ybase ) { ybase = ybase/10;} 
       else if (Ymax <= 7.5*ybase ) { ybase = ybase/2; }
    }    

    int x;
    int y;
    g.setColor(Color.black);
    // X-Achse
    g.drawLine (XKonv (-0.005), YKonv (0), XKonv (Xmax)+offset, YKonv (0));
    // Pfeil
    g.drawLine (XKonv (Xmax)+offset, YKonv (0), XKonv (Xmax)+offset-10, YKonv (0) - 5);
    g.drawLine (XKonv (Xmax)+offset, YKonv (0), XKonv (Xmax)+offset-10, YKonv (0) + 5);
    // Achsenbezeichnung
    g.drawString("X",XKonv(Xmax)+15, YKonv(0)+15);
    // X-Achse
    for (x = xbase; x <= Xmax; x = x + xbase) {
      g.drawLine (XKonv (x), YKonv (0) - 5, XKonv (x), YKonv (0) + 5);
      g.drawString (String.valueOf(x), XKonv (x), YKonv (0) + 15);
    }

    // Y-Achse
    g.drawLine (XKonv (0), YKonv(-0.5), XKonv (0), YKonv (Ymax)-offset);
    // Pfeil
    g.drawLine (XKonv (0), YKonv (Ymax)-offset, XKonv (0) - 5, YKonv (Ymax)-offset + 10);
    g.drawLine (XKonv (0), YKonv (Ymax)-offset, XKonv (0) + 5, YKonv (Ymax)-offset + 10);
    // Achsenbezeichnung
    g.drawString("Y", XKonv(0)-10, YKonv(Ymax)-15);
    // Beschriftung Y-Achse
    for (y = ybase; y <= Ymax; y = y + ybase) {
      g.drawLine (XKonv (0) - 5, YKonv (y), XKonv (0) + 5, YKonv (y));
      g.drawString (String.valueOf(y), XKonv (0) - 20 - (int) (Math.log(ybase)*3), YKonv (y));
    }
    // Legende X
    g.setColor(xcolor);
    g.drawLine ( g_weight - xoffset - 20 , yoffset - 5, g_weight - xoffset -5, yoffset -5 );
    g.drawString ("g(x)", g_weight - xoffset , yoffset);
    // Legende Y
    g.setColor(ycolor);
    g.drawLine ( g_weight - 2*xoffset - 20 , yoffset - 5, g_weight - 2*xoffset -5, yoffset -5 );
    g.drawString ("g(y)", g_weight - 2*xoffset , yoffset);
  }

  public void drawGxLine(Graphics g) {
    // g(x)
    g.setColor(xcolor);
    g.drawLine(XKonv(0),YKonv(bx),XKonv(Xmax),YKonv(ax*Xmax+bx));
    // g(y)
    g.setColor(ycolor);
    if ( (ay*Ymax+by) < by ) {
       g.drawLine(XKonv(0),YKonv(-by/ay),XKonv(by),YKonv(0));
    } else {
       g.drawLine(XKonv(0),YKonv(-by/ay),XKonv(ay*Ymax+by),YKonv(Ymax));
    }
  }

  public void drawXYPoints(Graphics g) {
    g.setColor(Color.red);
    for (int i=0; i < n; i++) {
      g.fillOval(XKonv(Double.parseDouble(String.valueOf(x.get(i)))),
	         YKonv(Double.parseDouble(String.valueOf(y.get(i)))),
	         dotwith,dotwith);
      }
  }

  public void drawBackground(Graphics g) {
    g.setColor(new Color(200,225,255));
    g.fillRect(0,0,g_weight,g_height);
  }

  public void drawText(Graphics g) {

    DecimalFormat df = new DecimalFormat( "0.00" );
    g.setColor(Color.black);

    g.drawString (s_n+String.valueOf(n), 10,20);

    g.drawString (gx+df.format(Math.round(ax*100)/100.0)+"x"+"+"+df.format(Math.round(bx*100)/100.0),10,40);
    g.drawString (gy+df.format(Math.round(ay*100)/100.0)+"y"+"+"+df.format(Math.round(by*100)/100.0),10,55);


    g.drawString (s_xquer+df.format(Math.round(xquer*100)/100.0),10,75);
    g.drawString (s_yquer+df.format(Math.round(yquer*100)/100.0),10,90);

    g.drawString (s_sxy+df.format(Math.round(sxy*100)/100.0),450,20);
    g.drawString (s_sx+df.format(Math.round(sx*100)/100.0),450,40);
    g.drawString (s_sy+df.format(Math.round(sy*100)/100.0),450,55);
    g.drawString (s_r+df.format(Math.round(r*100)/100.0),450,90);
  }

  public void setMaxima() {
    Xmax = Double.parseDouble(String.valueOf(x.get(0)));
    Ymax = Double.parseDouble(String.valueOf(y.get(0)));
    for (int i=1; i < n; i++ ) {
      if ( Double.parseDouble(String.valueOf(x.get(i))) >  Xmax ) {
        Xmax=Double.parseDouble(String.valueOf(x.get(i)));
      }
      if ( Double.parseDouble(String.valueOf(y.get(i))) >  Ymax ) {
	Ymax=Double.parseDouble(String.valueOf(y.get(i)));
      }
    }
  }

  public void setKovarianz(){
    double summanden = 0;
    for (int i=0; i < n; i++) {
    	summanden=summanden+(Double.parseDouble(String.valueOf(x.get(i)))-xquer)*(Double.parseDouble(String.valueOf(y.get(i)))-yquer);
    }
    sxy=1/((double) n -1)*summanden;
  }

  public void setStandardabwXandY(){
    for (int i=0; i <n; i++){
      Xsummanden=Xsummanden+Math.pow((Double.parseDouble(String.valueOf(x.get(i)))-xquer),2);
      Ysummanden=Ysummanden+Math.pow((Double.parseDouble(String.valueOf(y.get(i)))-yquer),2);
    }
    sx=Math.sqrt(1/((double) n -1)*Xsummanden);
    sy=Math.sqrt(1/((double) n -1)*Ysummanden);
  }
  public void setEmpKorr() {
    r=sxy/(sx*sy);
  }

  public void actionPerformed (ActionEvent e) {
    initValues(); // Rcksetzen der Berechnungen
    String tempX = new String();
    String tempY = new String();
    String s = null;
    n=jt.getRowCount();
    for (int i=0; i < n; i++) {
        try {

          if ( jt.getValueAt(i,0).toString().length()==0 || jt.getValueAt(i,1).toString().length()==0 ) {
            continue;
          }

          x.add(Double.valueOf(jt.getValueAt(i,0).toString().replace(',','.')));
          y.add(Double.valueOf(jt.getValueAt(i,1).toString().replace(',','.')));
          double xi=Double.valueOf(jt.getValueAt(i,0).toString().replace(',','.')).doubleValue();
	  double yi=Double.valueOf(jt.getValueAt(i,1).toString().replace(',','.')).doubleValue();

	  //Summierung von X-Werten
	  sumX=sumX+xi;
	  //Summierung von Y-Werten
  	  sumY=sumY+yi;
	  //Summierung von X^2-Werten
	  sumXhoch2=sumXhoch2+xi*xi;
	  //Summierung von Y^2-Werten
	  sumYhoch2=sumYhoch2+yi*yi;
	  //Summierung von X*Y-Werten
	  sumXY=sumXY+xi*yi;

          if (i==n-1){
	 	tempX=tempX+String.valueOf(x.get(i));
	        tempY=tempY+String.valueOf(y.get(i));
	  } else {
		tempX=tempX+String.valueOf(x.get(i))+",";
	        tempY=tempY+String.valueOf(y.get(i))+",";
	  }

       } catch(Exception exception) {
          n=i;
          break;
       }
    }
    n=x.size();
    // Alle Eintrge unterhalb der Hauptdiagonalen zu null machen
    if (sumX != 0){
    	double faktor = sumX/n;
    	double mod_sumXhoch2=(faktor*(-1)*sumX)+sumXhoch2;
	double mod_sumXY=(faktor*(-1)*sumY)+sumXY;
    	ax=mod_sumXY/mod_sumXhoch2;
	bx=(sumY-sumX*ax)/n;
    } else {
    // Berechnung des Gleichungssystems fr X unabhngig durch Rckwrteinsetzung
	ax=sumXY/sumXhoch2;
	bx=(sumY-sumX*ax)/n;
    }
    // Alle Eintrge unterhalb der Hauptdiagonalen zu null machen
    if (sumY != 0){
    	double faktor = sumY/n;
    	double mod_sumYhoch2=(faktor*(-1)*sumY)+sumYhoch2;
	double mod_sumXY=(faktor*(-1)*sumX)+sumXY;
    	ay=mod_sumXY/mod_sumYhoch2;
	by=(sumX-sumY*ay)/n;
    } else {
    // Berechnung des Gleichungssystems fr Y unabhngig durch Rckwrteinsetzung
    	ay=sumXY/sumYhoch2;
	by=(sumX-sumY*ay)/n;
    }

    // Berechnung der Mittelwerte
    xquer=sumX/n;
    yquer=sumY/n;
    // jetzt knnen wir die Standardabweichung,Kovarianz und emperischen Korellationskoeffizienten berechnen
    setStandardabwXandY();
    setKovarianz();
    setEmpKorr();
    // ermitteln der maximalen Werte
    setMaxima();
    // Skalierung setzen
    Xscale= x_weight / Xmax;
    Yscale= y_height / Ymax;

    Xwerte=Xwerte+tempX;
    Ywerte=Ywerte+tempY;
    // Text und Graphicfeld neuzeichnen
    pa.paintGraphic(this);
    ta.paintGraphic(this);
  }
}
