import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.lang.reflect.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import javax.swing.border.Border;
import java.text.DecimalFormat;


public class Konvidenzniveau extends JApplet

  implements ActionListener {

  private JLabel label1,label2,label3,label4;
  private JButton jb;
  private String s_n;
  private String s_xquer;
  private String s_xmax;
  private String s_alpha;
  private String s_p;
  private String s_sx;
  private String s_z;
  private String s_I;
  private Image img;
  private static final int offset=20;
  private static final int xoffset=80;
  private static final int yoffset=20;
  private static final int x_weight=550;
  private static final int y_height=300;
  public static final int g_weight=x_weight+2*yoffset+xoffset;
  public static final int g_height=y_height+2*yoffset+yoffset;

  private static final int g_xstart=280;
  private static final int g_ystart=90;
  private JPanel panel = new JPanel(new BorderLayout());
  private JPanel panel1 = new JPanel(new BorderLayout());
  private JPanel konvidenz = new JPanel(new BorderLayout());
  private JPanel subpanel1 = new JPanel(new BorderLayout());
  private JPanel table = new JPanel(new BorderLayout());
  String[][] data = new String[22][2];
  String[] columnNames = {"i","x"};
  public JTable jt = new JTable();
  private IndexRenderer ir = new IndexRenderer();
  private paintArea ca = new paintArea(this);
  private TextArea ct = new TextArea(this);
  private static final Color xcolor = Color.blue;
  private static final Color interavallcolor = Color.magenta;
  private static final Color xquercolor = Color.blue;

  public static final int dotwith= 5;
  private double [][] quantT = {
   { 3.078,   6.314,  12.707, 31.82,  63.654 },
   { 1.886,   2.92,   4.303,  6.965,  9.925 },
   { 1.638,   2.353,  3.182,  4.541,  5.841 },
   { 1.533,   2.132,  2.776,  3.747,  4.604 },
   { 1.476,   2.015,  2.571,  3.365,  4.032 },
   { 1.44,    1.943,  2.447,  3.143,  3.707 },
   { 1.415,   1.895,  2.365,  2.998,  3.499 },
   { 1.397,   1.86,   2.306,  2.896,  3.355 },
   { 1.383,   1.833,  2.262,  2.821,  3.25 },
   { 1.372,   1.812,  2.228,  2.764,  3.169 },
   { 1.363,   1.796,  2.201,  2.718,  3.106 },
   { 1.356,   1.782,  2.179,  2.681,  3.005 },
   { 1.35,    1.771,  2.16,   2.65,   3.012 },
   { 1.345,   1.761,  2.145,  2.624,  2.977 },
   { 1.341,   1.753,  2.131,  2.602,  2.947 },
   { 1.337,   1.746,  2.122,  2.583,  2.921 },
   { 1.333,   1.74,   2.11,   2.567,  2.898 },
   { 1.33,    1.734,  2.101,  2.552,  2.878 },
   { 1.328,   1.729,  2.093,  2.539,  2.861 },
   { 1.325,   1.725,  2.086,  2.528,  2.845 },
   { 1.321,   1.717,  2.074,  2.508,  2.819 }
  };
  private static final String[] prozent = { "80%","90%","95%","98%","99%" };
  private static final JComboBox selectProzent = new JComboBox(prozent);

  // Skalierung zwischen Koordinatensystem und Visualisierung
  private double Xscale;
  private double Yscale;
  // Anzahl von Werten
  private int n;
  // Standardabweichung
  private double sx;
  // Mittelwert
  private double xquer;
  // Maximalwert
  private double Xmax;
  private double alpha;
  private double niveau=0.9;
  private double p;
  private double sumX;
  private double z;
  private double Imin;
  private double Imax;


  private double Xsummanden;
  private double Ysummanden;

  // Liste von x und y Werten
  public ArrayList x = new ArrayList();

  public void init() {

    this.getContentPane().setLayout(new FlowLayout());
    initValues();

    label1 = new JLabel ("*** KONVIDENZNIVEAU-INTERVALL-GENERATOR ***");
    label2 = new JLabel (" Bitte geben Sie X-Werte in die Tabelle ein ");
    label3 = new JLabel (" Konvidenzniveau: ");

    jb = new JButton ("Neue Berechnung");
    jb.addActionListener(this);
    jb.setBackground(new Color(225,225,225));

    selectProzent.setBackground(new Color(225,225,225));

    jt = new JTable(data,columnNames);

    initCellRendrer();

    this.getContentPane().add(label1);

    konvidenz.add(label3,"Center");
    konvidenz.add(selectProzent ,"East");
    konvidenz.add(new JLabel("                             "),"West"); //Spacer

    subpanel1.add(label2, "West");
    subpanel1.add(konvidenz, "Center");
    subpanel1.add(jb, "East");

    table.add(jt.getTableHeader(),"North");
    table.add(jt,"South");

    panel.add(subpanel1,"North");
    panel.add(table,"West");
    panel.add(ca,"East");
    panel.add(ct,"South");

    this.getContentPane().add(panel);
  }

  public void initValues(){

    s_n="Anzahl von Stichproben n = ";
    s_sx = "Empirische Standardabweichung von x = ";
    s_xmax = String.valueOf(x_weight);
    s_xquer="Mittelwert von x = ";
    s_z="Quantil z = ";
    s_I="Konvidenzintervall = [ ";
    Xscale=1; Yscale=1;
    sx = 0;
    Xmax=0;
    Xsummanden = 0; Ysummanden = 0;
    n=0;
    sumX=0;
    x.clear();
    z=0;
    Imin=0;Imax=0;
  }

  public int XKonv (double Value) {
    return (int) (Value * Xscale) + xoffset;
  }

  public int YKonv (double Value) {
    return g_height - (int) (Value * Yscale) - yoffset;
  }

  public void initCellRendrer() {
    int columnCount = jt.getColumnCount();
    TableColumnModel colmod = jt.getColumnModel();
    TableColumn column = colmod.getColumn(1);
    column.setCellRenderer(ir);
    column = colmod.getColumn(0);
    column.setCellRenderer(ir);
    jt.setEditingColumn(1);
    colmod.setColumnSelectionAllowed(false);
  }

  public void paintKoordinatensystem (Graphics g) {

    int ybase = (int) Math.pow(10,String.valueOf((int) Xmax).length()-1);
    if ( ybase > 1 ) {
       if (Xmax <= 1.5*ybase ) { ybase = ybase/10;} 
       else if (Xmax <= 7.5*ybase ) { ybase = ybase/2; }
    }
    int xbase = 1;

    int x;
    int y;
    g.setColor(Color.black);
    // X-Achse
    g.drawLine (XKonv (-0.005), YKonv (0), XKonv (n)+offset, YKonv (0));
    // Pfeil
    g.drawLine (XKonv (n)+offset, YKonv (0), XKonv (n)+offset-10, YKonv (0) - 5);
    g.drawLine (XKonv (n)+offset, YKonv (0), XKonv (n)+offset-10, YKonv (0) + 5);
    // Achsenbezeichnung
    g.drawString("i",XKonv(n)+15, YKonv(0)+15);
    // X-Achse
    for (x = xbase; x <= n; x = x + xbase) {
      g.drawLine (XKonv (x), YKonv (0) - 5, XKonv (x), YKonv (0) + 5);
      g.drawString (String.valueOf(x), XKonv (x), YKonv (0) + 15);
    }

    // Y-Achse
    g.drawLine (XKonv (0), YKonv(-0.5), XKonv (0), YKonv (Xmax)-offset);
    // Pfeil
    g.drawLine (XKonv (0), YKonv (Xmax)-offset, XKonv (0) - 5, YKonv (Xmax)-offset + 10);
    g.drawLine (XKonv (0), YKonv (Xmax)-offset, XKonv (0) + 5, YKonv (Xmax)-offset + 10);
    // Achsenbezeichnung
    g.drawString("X", XKonv(0)-10, YKonv(Xmax)-15);
    // Beschriftung Y-Achse
    for (y = ybase; y <= Xmax; y = y + ybase) {
      g.drawLine (XKonv (0) - 5, YKonv (y), XKonv (0) + 5, YKonv (y));
      g.drawString (String.valueOf(y), XKonv (0) - 20 - (int) (Math.log(ybase)*3), YKonv (y));
    }
  }
  public void drawXquerLine(Graphics g) {
    g.setColor(xquercolor);
    g.drawLine(XKonv(0),YKonv(xquer),XKonv(n),YKonv(xquer));
    g.drawString("x",XKonv(n)+10,YKonv(xquer));
    g.drawLine(XKonv(n)+10,YKonv(xquer)-10,XKonv(n)+15,YKonv(xquer)-10);

  }
  public void drawKonvidenzIntervallLines(Graphics g) {
    g.setColor(interavallcolor);
    g.drawLine(XKonv(0),YKonv(Imin),XKonv(n),YKonv(Imin));
    g.drawString("I min",XKonv(n)+5,YKonv(Imin)+10);
    g.drawLine(XKonv(0),YKonv(Imax),XKonv(n),YKonv(Imax));
    g.drawString("I max",XKonv(n)+5,YKonv(Imax));
  }

  public void drawXPoints(Graphics g) {
    g.setColor(Color.red);
    for (int i=0; i < n; i++) {
      g.fillOval(XKonv(i+1),
	         YKonv(Double.parseDouble(String.valueOf(x.get(i)))),
	         dotwith,dotwith);
      }
  }

  public void drawBackground(Graphics g) {
    g.setColor(new Color(200,225,255));
    g.fillRect(0,0,g_weight,g_height);
  }

  public void drawText(Graphics g) {

    DecimalFormat df = new DecimalFormat( "0.00" );
    g.setColor(Color.black);
    g.drawString (s_n+String.valueOf(n), 10,20);
    g.drawString (s_sx+df.format(Math.round(sx*100)/100.0),10,35);
    g.drawString (s_xquer+df.format(Math.round(xquer*100)/100.0),10,50);
    g.drawString (s_z+df.format(Math.round(z*100)/100.0),10,65);
    g.drawString (s_I+df.format(Math.round(Imin*100)/100.0)+" , "+df.format(Math.round(Imax*100)/100.0)+" ]",10,80);
  }

  public void setMaxima() {
    Xmax = Double.parseDouble(String.valueOf(x.get(0)));
    for (int i=1; i < n; i++ ) {
      if ( Double.parseDouble(String.valueOf(x.get(i))) >  Xmax ) {
        Xmax=Double.parseDouble(String.valueOf(x.get(i)));
      }
    }
  }

  public void setStandardabwX(){
    for (int i=0; i <n; i++){
      Xsummanden=Xsummanden+Math.pow((Double.parseDouble(String.valueOf(x.get(i)))-xquer),2);
    }
    sx=Math.sqrt(1/((double) n -1)*Xsummanden);
  }
  public void setZ() {
      z=quantT[n-2][selectProzent.getSelectedIndex()];
  }
  public void setKonvidenzIntervall() {
    Imin=xquer-(z*sx)/Math.sqrt(n);
    Imax=xquer+(z*sx)/Math.sqrt(n);
  }
  public int getN() { return n; }

  public void actionPerformed (ActionEvent e) {
    initValues();
    n=jt.getRowCount();
    for (int i=0; i < n; i++) {
        try {

          if ( jt.getValueAt(i,1).toString().length()==0 ) {
            continue;
          }

          x.add(Double.valueOf(jt.getValueAt(i,1).toString().replace(',','.')));

          double xi=Double.valueOf(jt.getValueAt(i,1).toString().replace(',','.')).doubleValue();

	  //Summierung von X-Werten
	  sumX=sumX+xi;
	  //Summierung von Y-Werten


       } catch(Exception exception) {
          n=i;
          break;
       }
    }
    n=x.size();
    xquer=sumX/n;
    setMaxima();
    setStandardabwX();
    setZ();
    if ( n > 1 ) {
      setKonvidenzIntervall();
    }
    if ( Imax > Xmax ) {
        Yscale= y_height / Imax;
        Xmax = Imax;
    } else {
        Yscale= y_height / Xmax;
    }
    Xscale= x_weight / n;
    ca.paintGraphic(this);
    ct.paintGraphic(this);

  }
}


class IndexRenderer extends DefaultTableCellRenderer {
    private int firstColoumn;
    public Component getTableCellRendererComponent(
           JTable table,
           Object value,
           boolean isSelected,
           boolean hasFocus,
           int row,
           int column) {

        super.getTableCellRendererComponent(table, value, isSelected,
                                            hasFocus, row, column);

        if ( table.getValueAt(row,column) == null || table.getValueAt(row,column) == ""){
           table.setValueAt(new String(""),row,0);
        }
        if (hasFocus) {
           table.setValueAt(new String(String.valueOf(row+1)),row,0);
        }
        return this;
    }
}

class paintArea extends JPanel {
    Point point = null;
    Dimension preferredSize = new Dimension(600,500);
    Konvidenzniveau kn;
    public paintArea(Konvidenzniveau KN) {
        this.kn = KN;
        Border raisedBevel = BorderFactory.createRaisedBevelBorder();
        Border loweredBevel = BorderFactory.createLoweredBevelBorder();
        Border compound = BorderFactory.createCompoundBorder
                              (raisedBevel, loweredBevel);
        setBorder(compound);
        repaint();
    }
    public void paintGraphic(Konvidenzniveau KN) {
        this.kn = KN; repaint();
    }
    public void paintComponent(Graphics g) {
        super.paintComponent(g);  //paint background
        kn.drawBackground(g);
        kn.paintKoordinatensystem(g);
        kn.drawXPoints(g);
        if (kn.getN() > 1) {
           kn.drawXquerLine(g);
           kn.drawKonvidenzIntervallLines(g);
        }
    }
    public Dimension getPreferredSize() {
        preferredSize = new Dimension(kn.g_weight,kn.g_height);
        return preferredSize;
    }

}

class TextArea extends JPanel {
    Point point = null;
    private static final int weight=800;
    private static final int height=100;
    Dimension preferredSize = new Dimension(weight,height);
    Konvidenzniveau kn;
    public TextArea(Konvidenzniveau KN) {
        this.kn = KN;
        Border raisedBevel = BorderFactory.createRaisedBevelBorder();
        Border loweredBevel = BorderFactory.createLoweredBevelBorder();
        Border compound = BorderFactory.createCompoundBorder
                              (raisedBevel, loweredBevel);
        setBorder(compound);
        repaint();
    }
    public void paintGraphic(Konvidenzniveau KN) {
        this.kn = KN; repaint();
    }
    public void paintComponent(Graphics g) {
        super.paintComponent(g);  //paint background
        drawBackground(g);
        kn.drawText(g);
    }
    public Dimension getPreferredSize() {
        return preferredSize;
    }
    public void drawBackground(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0,0,weight+20,height);
  }

}
